<?php

namespace App\Http\Controllers;

use App\Audio;
use App\Button;
use App\Config;
use App\LiveEvent;
use App\Movie;
use App\MovieSeries;
use App\MultipleLinks;
use App\Season;
use App\TvSeries;
use App\User;
use App\UserRating;
use Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;


class PrimeDetailController extends Controller
{
   

    /**
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View|void
     */

    public function __construct()
    {
        $this->button = Button::first();
    }

    public function showMovie($slug)
    {
        $movie = Movie::with(['menus' => function ($q) {
            return $q->select('movie_id', 'menu_id');
        }])->where('slug', $slug)->where('status', 1)->first();
    
        if (isset($movie) && $movie != NULL) {
            $type_check = "M";
            $movies = Movie::all();
            $config = Config::findOrFail(1);
            $filter_series = collect();
            $age = 0;
    
            if (!isset($movie)) {
                return back()->with('deleted', __('Movie Is Not Available right now, Please comeback later !'));
            }
    
            if ($config->age_restriction == 1) {
                if (Auth::check()) {
                    $user_id = Auth::user()->id;
                    $user = User::findOrfail($user_id);
                    $age = $user->age;
                }
            } else {
                $age = 100;
            }
    
            if ($this->button->countviews != 1) {
                views($movie)->record();
            }
    
            if ($movie->series == 1) {
                $single_series_list = MovieSeries::where('series_movie_id', $movie->id)->first();
    
                if (isset($single_series_list)) {
                    $main_movie_series = Movie::where('id', $single_series_list->movie_id)->first();
                    $filter_series->push($main_movie_series);
                    $series_list = (MovieSeries::where([
                        ['movie_id', $main_movie_series->id],
                        ['series_movie_id', '!=', $movie->id]
                    ])->get());
    
                    foreach ($series_list as $item) {
                        $filter_movie_exc_self = Movie::where('id', $item->series_movie_id)->first();
                        $filter_series->push($filter_movie_exc_self);
                    }
                }
            }
    
            $movieRating = UserRating::where('movie_id', $movie->id)->get();
    
            // Default currency variables
            $converted_amount = null;
            $converted_price = null;
            $converted_offer_price = null;
            $converted_symbol = null;
            $converted_code = null;

            // Currency conversion logic only if ppv == 1
            if ($movie->ppv == 1) {
                $price = $movie->offer_price ?? $movie->price;
                $base_currency = $config->currency_code;
                $converted_price = (Session::has('current_currency'))
                    ? round(currency($movie->price, $from = $base_currency, $to = ucfirst(Session::get('current_currency')), $format = false), 2)
                    : round($movie->price, 2);
                    $converted_offer_price = null;

                    if (isset($movie->offer_price) && $movie->offer_price != null) {
                        $converted_offer_price = (Session::has('current_currency'))
                            ? round(currency($movie->offer_price, $from = $base_currency, $to = ucfirst(Session::get('current_currency')), $format = false), 2)
                            : round($movie->offer_price, 2);
                    }
    
                $converted_amount = (Session::has('current_currency'))
                    ? round(currency($price, $from = $base_currency, $to = ucfirst(Session::get('current_currency')), $format = false), 2)
                    : round($price, 2);
    
                $converted_symbol = DB::table('currencies')
                    ->where('code', ucfirst(Session::get('current_currency')))
                    ->value('symbol') ?? DB::table('currencies')->where('active', 1)->value('symbol');
    
                $converted_code = DB::table('currencies')
                    ->where('code', ucfirst(Session::get('current_currency')))
                    ->value('code') ?? DB::table('currencies')->where('active', 1)->value('code');
            }
    
            // Choose view
            if ($config->prime_movie_single == 1) {
                return view('movie_single_prime', compact(
                    'movie', 'movies', 'filter_series', 'type_check', 'age', 'config', 'movieRating',
                    'converted_amount', 'converted_symbol', 'converted_code', 'converted_price', 'converted_offer_price'
                ));
            } else {
                return view('movie_single', compact(
                    'movie', 'movies', 'filter_series', 'type_check', 'age', 'config', 'movieRating',
                    'converted_amount', 'converted_symbol', 'converted_code', 'converted_price', 'converted_offer_price'
                ));
            }
        }
    }
    

    public function showSeasons($season_slug)
{
    $season = Season::where('season_slug', $season_slug)->first();

    if (isset($season) && $season != NULL) {
        $type_check = "S";
        $movies = Movie::all();
        $config = Config::findOrFail(1);
        $age = 0;

        if ($this->button->countviews != 1) {
            views($season)->record();
        }

        if ($season->tvseries->status != 1) {
            return back()->with('deleted', __('This Season is not available right now, Please comeback later !'));
        }

        if ($config->age_restriction == 1) {
            if (Auth::check()) {
                $user_id = Auth::user()->id;
                $user = User::findOrfail($user_id);
                $age = $user->age;
            }
        } else {
            $age = 100;
        }

        // Currency conversion logic only if ppv == 1
        $price = $season->offer_price ?? $season->price;
        $base_currency = $config->currency_code;
        $converted_amount = null;
        $converted_price = null;
        $converted_offer_price = null;
        $converted_symbol = null;   
        $converted_code = null;
        if ($season->ppv == 1) {  // Check if PPV
            $converted_price = (Session::has('current_currency'))
                ? round(currency($season->price, $from = $base_currency, $to = ucfirst(Session::get('current_currency')), $format = false), 2)
                : round($season->price, 2);
            $converted_offer_price = null;
            if (isset($season->offer_price) && $season->offer_price != null) {
                $converted_offer_price = (Session::has('current_currency'))
                    ? round(currency($season->offer_price, $from = $base_currency, $to = ucfirst(Session::get('current_currency')), $format = false), 2)
                    : round($season->offer_price, 2);
            }

            $converted_amount = (Session::has('current_currency'))
                ? round(currency($price, $from = $base_currency, $to = ucfirst(Session::get('current_currency')), $format = false), 2)
                : round($price, 2);

            $converted_symbol = DB::table('currencies')
                ->where('code', ucfirst(Session::get('current_currency')))
                ->value('symbol') ?? DB::table('currencies')->where('active', 1)->value('symbol');

            $converted_code = DB::table('currencies')
                ->where('code', ucfirst(Session::get('current_currency')))
                ->value('code') ?? DB::table('currencies')->where('active', 1)->value('code');
        }

        if ($config->prime_movie_single == 1) {
            return view('movie_single_prime', compact(
                'season', 'age', 'movies', 'type_check', 'config',
                'converted_amount', 'converted_symbol', 'converted_code', 'converted_price', 'converted_offer_price'
            ));
        } else {
            return view('movie_single', compact(
                'season', 'age', 'movies', 'type_check', 'config',
                'converted_amount', 'converted_symbol', 'converted_code', 'converted_price', 'converted_offer_price'
            ));
        }
    } else {
        abort(404);
    }
}
    


    public function moviedownload($upload_video)
    {

        $file = $upload_video;

        $path = public_path() . "/movies_upload/" . $upload_video;
        $headers = array(
            'Content-Type : application/pdf',
        );
        return response()->download($path, $file, $headers);
    }

    public function seasondownload($upload_video)
    {

        $file = $upload_video;

        $path = public_path() . "/tvshow_upload/" . $upload_video;
        $headers = array(
            'Content-Type : application/pdf',
        );
        return response()->download($path, $file, $headers);

    }

    public function updateclick(Request $request)
    {
        $link = MultipleLinks::find($request->id);

        if (isset($link)) {
            $link->clicks = $link->clicks + 1;
            $link->save();

            return response()->json('Updated !');
        } else {
            return response()->json('Oops error');
        }
    }

    public function eventshow($slug)
    {
        $liveevent = LiveEvent::where('status', '=', '1')->where('slug', $slug)->first();
        if (!isset($liveevent)) {
            return abort(404);
        }

        return view('event_detail', compact('liveevent'));

    }

    public function audioshow($id)
    {
        $audio = Audio::where('id', $id)->first();
        if (!isset($audio)) {
            return abort(404);
        }

        return view('audio_detail', compact('audio'));

    }

}